// config: norepeat noautolaunch

#include "GetObjects.js"
#include "WaitForDialogDone.js"

function DoNSided()
{
	var objectpicker = moi.ui.createObjectPicker();
	objectpicker.allowEdgeCurves();
	
	if ( !GetObjects( objectpicker ) )
		return;
		
	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectPrompt' );
	moi.ui.showUI( 'OptionsPrompt' );
	moi.ui.showUI( 'Options' );	
	moi.ui.endUIUpdate();
		
	var factory = moi.command.createFactory( 'nsided' );
	factory.setInput( 0, objectpicker.objects );
	
	factory.disableUpdate( true );
	moi.ui.bindUIToInput( 'bulge', 'value', factory.getInput(1) );
	moi.ui.bindUIToInput( 'numu', 'value', factory.getInput(2) );
	moi.ui.bindUIToInput( 'numv', 'value', factory.getInput(3) );
	factory.disableUpdate( false );
	factory.update();

	if ( !WaitForDialogDone() )
		return;	
	
	factory.commit();
}

DoNSided();
